const express = require('express');
const router = express.Router();
const notesController = require('../controllers/notesController');
const multer = require('multer');
const path = require('path');

// Configure Multer for file uploads
const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        cb(null, 'uploads/');
    },
    filename: function (req, file, cb) {
        cb(null, Date.now() + path.extname(file.originalname));
    }
});

const upload = multer({ storage: storage });

router.get('/', notesController.getNotes);
router.post('/', upload.single('image'), notesController.createNote);

module.exports = router;
